

package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bTramites;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bTramitesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaTramitesExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaTramitesExcelAction extends Q70ActionPasoOP{

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoTramites.xls";
		InputStream inputStream = W83bTablaTramitesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaTramites = (ArrayList)contexto.get("w83bListaTramites");
        W83bTramitesBean tramBean = (W83bTramitesBean)contexto.get("w83bTramitesTempBean");                  
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                  

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                  
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                  
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                  
        HashMap mapaTramites=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                  
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                  
        HSSFCell cell = row.createCell((short)3);                  
        row = sheet.getRow((short)4);                  
        cell = row.getCell((short)2);                  
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaTramites.get("tituloDepEs");                  
        StringBuffer tituloImagenEu =  (StringBuffer)mapaTramites.get("tituloDepEu");                  
        cell.setCellValue(tituloImagenEu.toString());                  
        
        cell = row.getCell((short)6);                  
        cell.setCellValue(tituloImagenEs.toString());                  
        
        tituloImagenEs = (StringBuffer)mapaTramites.get("tituloDelelegacionEs");                  
        tituloImagenEu = (StringBuffer)mapaTramites.get("tituloDelelegacionEu");                  

        row = sheet.getRow((short)6);                  
        cell = row.getCell((short)2);                  
        cell.setCellValue(tituloImagenEu.toString());                  
        
        cell = row.getCell((short)6);                  
        cell.setCellValue(tituloImagenEs.toString());                  
        
        row = sheet.getRow((short)9);                  
        cell = row.getCell((short)0);                  
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.listadoTramites").toUpperCase());                  
        
        //MAPEO FORMULARIO
      //fila 10, columna 2
        row = sheet.getRow((short)12);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.codTramiteTabla"));
        cell = row.createCell((short)3);
        if(!StringUtils.isEmpty(tramBean.getCodTramite())){
        	cell.setCellValue(W83bUtilidades.numero(tramBean.getCodTramite()));

        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
      //fila 11, columna 2
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.codFaseTabla"));
        cell = row.createCell((short)9);
        if((!StringUtils.isEmpty(tramBean.getFaseDesc())&&W83bClsConstantes.CONSTANTE_CASTELLANO.equalsIgnoreCase(idioma))||(!StringUtils.isEmpty(tramBean.getFaseDescEusk())&&W83bClsConstantes.CONSTANTE_EUSKARA.equalsIgnoreCase(idioma))){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("9"),W83bClsConstantes.DOCE,Short.parseShort("10")));//NOPMD
	        if(W83bClsConstantes.CONSTANTE_CASTELLANO.equalsIgnoreCase(idioma)){
	        	cell.setCellValue(tramBean.getFaseDesc());
	        }else{
	        	cell.setCellValue(tramBean.getFaseDescEusk());
	        }
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
              
      //fila 12, columna 2
        row = sheet.getRow((short)13);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.descTramiteTabla"));
        cell = row.createCell((short)3);
        if(StringUtils.isNotEmpty(tramBean.getDescTramite())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("3"),W83bClsConstantes.TRECE,Short.parseShort("5")));//NOPMD
        	cell.setCellValue(tramBean.getDescTramite().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        //fila 13, columna 2
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.descTramiteEuskTabla"));
        cell = row.createCell((short)9);
        if(StringUtils.isNotEmpty(tramBean.getDescTramiteEusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("9"),W83bClsConstantes.TRECE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(tramBean.getDescTramiteEusk().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        if(StringUtils.isNotEmpty(tramBean.getDescTramiteEusk()) && StringUtils.isNotEmpty(tramBean.getDescTramite())){
	    	if((tramBean.getDescTramite()).length()>=(tramBean.getDescTramiteEusk()).length()){
	        	if(47<(tramBean.getDescTramite()).length()){
	        		row.setHeightInPoints((short)(20*((tramBean.getDescTramite()).length()/47)+1));
	        	}
	        }else{
	        	if(41<(tramBean.getDescTramiteEusk()).length()){
	        		row.setHeightInPoints((short)(20*((tramBean.getDescTramiteEusk()).length()/41)+1));
	        	}
	        }
        }
      
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamanyo columna en chars)/(1/20)
        row = sheet.getRow((short)16); // Creacin de la fila 16
        cell = row.getCell((short)0); // Creacin de la columna 2 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.codTramiteTabla"));
        
        cell = row.getCell((short)1); // Creacin de la columna 3 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.codFaseTabla"));
        
        cell = row.getCell((short)2); // Creacin de la columna 4 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.descTramiteTabla"));
        
        // 3 columna del titulo del listado
        cell = row.getCell((short)7); // Creacin de la columna 5 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tramites.descTramiteEuskTabla"));


        for(int i=0;i<listaTramites.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 17

        	//Cod Voz
        	cell = row.createCell((short)0);
        	if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getCodTramite())){
        		 cell.setCellValue(W83bUtilidades.numero(((W83bTramitesBean)listaTramites.get(i)).getCodTramite()));
             }else{
             	cell.setCellValue("");
             }
        	
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	//Cod TiposVoz
        	cell = row.createCell((short)1);
        	if(W83bClsConstantes.CONSTANTE_CASTELLANO.equalsIgnoreCase(idioma)){
        		if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getFaseDesc())){
        			cell.setCellValue(((W83bTramitesBean)listaTramites.get(i)).getFaseDesc());
                }else{
                	cell.setCellValue("");
                }
        		
        	}else{
        		if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getFaseDescEusk())){
        			cell.setCellValue(((W83bTramitesBean)listaTramites.get(i)).getFaseDescEusk());
                }else{
                	cell.setCellValue("");
                }
        		
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Descripcin Voz
        	cell = row.createCell((short)2);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("2"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("6")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getDescTramite())){
        		cell.setCellValue(((W83bTramitesBean)listaTramites.get(i)).getDescTramite());
            }else{
            	cell.setCellValue("");
            }
        	
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6")); 
        	cell.setCellStyle(this.estiloFila(i,excel));

        	//Descripcin VozEusk
        	cell = row.createCell((short)7);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("7"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk())){
        		cell.setCellValue(((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk());
            }else{
            	cell.setCellValue("");
            }
        	
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	if(StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getDescTramite()) 
        			&& StringUtils.isNotEmpty(((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk())){        	
        	
	        	if((((W83bTramitesBean)listaTramites.get(i)).getDescTramite()).length()>=(((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk()).length()){
		        	if(55<(((W83bTramitesBean)listaTramites.get(i)).getDescTramite()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bTramitesBean)listaTramites.get(i)).getDescTramite()).length()/55)+1));
		        	}
		        }else{
		        	if(55<(((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bTramitesBean)listaTramites.get(i)).getDescTramiteEusk()).length()/55)+1));
		        	}
		        }
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoTramites.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
		
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
	
}
